<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_features extends Widget_Base {

	public function get_name() {
		return 'applic-features';
	}

	public function get_title() {
		return __( 'Features', 'applic-core' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		/* ------------------------------  features content tab ------------------------------
		-------------------------------------------------------------------------------------*/
		/*-------------------------------- section content --------------------------------*/
		$this->start_controls_section(
			'section_id',
			[
				'label' => __( 'Section Content', 'applic-core' ),
			]
		);
		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Powerful Set of Products & Features'
			]
		);
		$this->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'APP FEATURES'
			]
		);
		$this->end_controls_section(); // End section content

		/*-------------------------------- Features List --------------------------------*/
		$this->start_controls_section(
			'feature_id',
			[
				'label' => __( 'Features List', 'applic-core' ),
			]
		);
		$this->add_control(
			'features', [
				'label'       => __( 'Features', 'applic-core' ),
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ title }}}',
				'fields'      => [
					[
						'name'        => 'title',
						'label'       => __( 'Feature name', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'Online <br> Meeting'
					],
					[
						'name'        => 'f_icon',
						'label'       => __( 'Icon', 'applic-core' ),
						'type'        => Controls_Manager::ICON,
						'label_block' => true
					]
				],
			]
		);
		$this->end_controls_section(); // End title section


		/*-------------------------------- Features Style Tab --------------------------------*/
		/*----------------------- section title and subtitle ---------------------------- */
		$this->start_controls_section(
			'sec_style', [
				'label' => __( 'Section Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color', [
				'label'     => __( 'Title Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .features-area .area-title h2' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_title',
				'selector' => '{{WRAPPER}} .features-area .area-title h2',
			]
		);
		$this->add_control(
			'subtitle_color', [
				'label'     => __( 'Subtitle Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .features-area .subtitle' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_subtitle',
				'selector' => '{{WRAPPER}} .features-area .subtitle',
			]
		);
		$this->end_controls_section();

		/*----------------------- Features List Style  ---------------------------- */
		$this->start_controls_section(
			'feature_style', [
				'label' => __( 'Features List Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'f_title_c', [
				'label'     => __( 'Title Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .single-features h3' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'icon_color', [
				'label'     => __( 'Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-features .box-icon i' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'i_bg_color', [
				'label' => __( 'Icon Background Color', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'i_bg_color2', [
				'label' => __( 'Icon Background Color 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-features .box-icon' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{i_bg_color.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
				],
			]
		);

		$this->start_controls_tabs(
			'owl_nav_tabs'
		);
		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);
		$this->add_control(
			'owl_nav_color',
			[
				'label'     => __( 'Owl Navigation Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-nav > div' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'owl_nav_hover_tab',
			[
				'label' => __( 'Hover', 'applic-core' ),
			]
		);
		$this->add_control(
			'owl_nav_color_hover',
			[
				'label'     => __( 'Owl Navigation Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-nav > div:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {
	    $this->load_widget_script();
		$settings = $this->get_settings();
		?>
        <!--FEATURES AREA-->
        <section class="features-area section-padding fix">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                        <div class="area-title sm-center xs-center">
							<?php if ( ! empty( $settings['subtitle'] ) ): ?>
                                <h4 class="subtitle"><?php echo esc_html( $settings['subtitle'] ); ?></h4>
							<?php endif; ?>
							<?php if ( ! empty( $settings['title'] ) ): ?>
                                <h2><?php echo esc_html( $settings['title'] ); ?></h2>
							<?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="features-slider">
							<?php foreach ( $settings['features'] as $feature ) { ?>
                                <div class="text-icon-box single-features">
                                    <div class="box-icon"><i class="<?php echo esc_attr( $feature['f_icon'] ); ?>"></i>
                                    </div>
                                    <h3><?php echo $feature['title']; ?></h3>
                                </div>
							<?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--FEATURES AREA END-->
		<?php
	}

    public function load_widget_script(){
        if( \Elementor\Plugin::$instance->editor->is_edit_mode() === true  ) {
            ?>
            <script>
                ( function( $ ){

                    var serviceCarousel = jQuery('.features-slider');
                    if (serviceCarousel.length > 0) {
                        serviceCarousel.owlCarousel({
                            merge: true,
                            smartSpeed: 1000,
                            loop: true,
                            nav: true,
                            center: false,
                            dots: false,
                            navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                            autoplay: false,
                            autoplayTimeout: 3000,
                            margin: 0,
                            responsiveClass: true,
                            responsive: {
                                0: {
                                    center: true,
                                    nav: false,
                                    dots: true,
                                    items: 1
                                },
                                600: {
                                    nav: false,
                                    dots: true,
                                    items: 3
                                },
                                1000: {
                                    items: 4
                                },
                                1200: {
                                    items: 5
                                }
                            }
                        });
                    }

                })(jQuery);
            </script>
            <?php
        }
    }

}
