<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;


// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_faq extends Widget_Base
{

    public function get_name()
    {
        return 'applic-faq';
    }

    public function get_title()
    {
        return __('FAQ', 'applic-core');
    }

    public function get_icon()
    {
        return 'eicon-click';
    }

    public function get_categories()
    {
        return ['applic-elements'];
    }

    protected function _register_controls()
    {

        /* ------------------------------  FAQ content tab ------------------------------
        -------------------------------------------------------------------------------------*/
        /*-------------------------------- section content --------------------------------*/
        $this->start_controls_section(
            'section_id',
            [
                'label' => __('Section Content', 'applic-core'),
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__('Title', 'applic-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Frequently Asked Questions'
            ]
        );
        $this->add_control(
            'subtitle', [
                'label' => esc_html__('Subtitle', 'applic-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'ASK QUESTIONS'
            ]
        );
        $this->end_controls_section(); // End section content

        /*-------------------------------- FAQ List --------------------------------*/
        $this->start_controls_section(
            'faq_id',
            [
                'label' => __('FAQ', 'applic-core'),
            ]
        );
        $this->add_control(
            'faqs', [
                'label' => __('FAQ', 'applic-core'),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ title }}}',
                'fields' => [
                    [
                        'name' => 'title',
                        'label' => __('Feature name', 'applic-core'),
                        'type' => Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => 'Creating The Feature Queries Manager ?'
                    ],
                    [
                        'name' => 'desc',
                        'label' => __('Icon', 'applic-core'),
                        'type' => Controls_Manager::TEXTAREA,
                        'label_block' => true,
                        'default' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do ei temporo incididunt ut labore et dolore magna aliqua. Ut enim ad minim exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute dolor in reprehenderit in voluptate velit esse cillum dolore'
                    ]
                ],
            ]
        );
        $this->end_controls_section(); // End FAQ

        /*-------------------------------- Feature Image --------------------------------*/
        $this->start_controls_section(
            'img_id',
            [
                'label' => __('FAQ Image', 'applic-core'),
            ]
        );
        $this->add_control(
            'style', [
                'label' => esc_html__('FAQ Image Layer', 'applic-core'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    'layer_1' => esc_html__('Layer One', 'applic-core'),
                    'layer_2' => esc_html__('Layer Two', 'applic-core')
                ],
                'default' => 'layer_1'
            ]
        );
        $this->add_control(
            'faq_img',
            [
                'label' => __('Faq Image', 'applic-core'),
                'type' => Controls_Manager::MEDIA
            ]
        );
        $this->add_control(
            'q_img',
            [
                'label' => __('Quotation Marks', 'applic-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'applic-core' ),
                'label_off' => __( 'Hide', 'applic-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition'   => [
                    'style' => 'layer_1',
                ],
            ]
        );
        $this->end_controls_section(); // End section content


        /*-------------------------------- FAQ Style Tab --------------------------------*/
        /*
         * Faq Section Style
         * */
        $this->start_controls_section(
            'faq_bg_id',
            [
                'label' => __('Section Style', 'applic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'faq_bg',
            [
                'label' => __('Background Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
                 'selectors' => [
                    '{{WRAPPER}} .faqs-area' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'sec_padding', [
                'label' => __('Section padding', 'applic-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .faqs-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '100',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px', // The selected CSS Unit. 'px', '%', 'em',
                    'isLinked' => false,
                ],
            ]
        );

        $this->end_controls_section();
        /*----------------------- section title and subtitle ---------------------------- */
        $this->start_controls_section(
            'sec_content_style', [
                'label' => __('Section Content Style', 'applic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color', [
                'label' => __('Title Text Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faqs-area .area-content h2' => 'color: {{VALUE}};',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_title',
                'selector' => '{{WRAPPER}} .faqs-area .area-content h2',
            ]
        );
        $this->add_control(
            'subtitle_color', [
                'label' => __('Subtitle Text Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
                 'selectors' => [
                    '{{WRAPPER}} .faqs-area .area-content h4' => 'color: {{VALUE}};',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_subtitle',
                'selector' => '{{WRAPPER}} .faqs-area .area-content h4',
            ]
        );
        $this->end_controls_section();

        /*----------------------- FAQ List Style  ---------------------------- */
        $this->start_controls_section(
            'faq_style', [
                'label' => __('FAQ Accordion Style', 'applic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'faq_tab'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => __('Normal', 'applic-core'),
            ]
        );

        $this->add_control(
            'a_title_color', [
                'label' => __('Title Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faqs-area .panel-title' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'active_tab',
            [
                'label' => __('Active', 'applic-core'),
            ]
        );
        $this->add_control(
            'a_desc_color_a', [
                'label' => __('Text Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .faqs-area .active .panel-title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .faqs-area .active .panel-body' => 'color: {{VALUE}};',
                ]
            ]
        );
        $this->add_control(
            'a_title_color_a', [
                'label' => __('Title Hover Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .panel-title:hover' => 'color: {{VALUE}};',
                ]
            ]
        );


        $this->add_control(
            'a_g_bg_color', [
                'label' => __('Background Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'a_g_bg_color2', [
                'label' => __('Background Color 02', 'applic-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .panel.panel-default.active' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{a_g_bg_color.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        $faqs = isset($settings['faqs']) ? $settings['faqs'] : '';
        ?>
        <!--FAQS AREA-->
        <section class="faqs-area">
            <div class="container">
                <div class="row">
                    <?php if ($settings['style'] == 'layer_1') { ?>
                        <div class="col-md-6 col-lg-6 col-xs-12">
                            <div class="area-image-content hidden-sm hidden-xs">
                                <div class="faqs-mockup-1" data-parallax='{"y": 150, "smoothness": 100}'><img
                                            src="<?php echo esc_url($settings['faq_img']['url']); ?>"
                                            alt="FAQ Image"></div>
                                <?php if ( 'yes' === $settings['q_img'] ): ?>
                                    <div class="faqs-mockup-2"><img
                                                src="<?php echo plugin_dir_url(__FILE__) . 'images/faqs-question.png'; ?>"
                                                alt="FAQ Image"></div>
                                <?php endif;?>
                            </div>
                        </div>
                    <?php
                        }elseif ($settings['style'] == 'layer_2') {
                        ?>
                        <div class="col-md-6 col-lg-5 col-xs-12">
                            <div class="area-image-content hidden-sm hidden-xs">
                                <img src="<?php echo esc_url($settings['faq_img']['url']); ?>" alt="FAQ Image">
                            </div>
                        </div>
                    <?php
                        } ?>
                    <?php if ($settings['style'] == 'layer_1') { ?>
                        <div class="col-md-6 col-lg-6 col-xs-12">
                    <?php
                        } elseif ($settings['style'] == 'layer_2') {
                        ?>
                        <div class="col-md-6 col-lg-6 col-lg-offset-1 col-xs-12">
                    <?php
                        } ?>
                        <div class="area-content">
                            <h4 class="subtitle font500 alt-font uppercase"><?php echo esc_html($settings['subtitle']); ?></h4>
                            <h2><?php echo esc_html($settings['title']); ?></h2>
                            <div class="panel-group sm-mt50 xs-mt50" id="accordion-main">
                                <?php
                                $i = 1;
                                foreach ($faqs as $faq):
                                    $active = $i == 1 ? 'active' : '';
                                    $in = $i == 1 ? 'in' : '';
                                    ?>
                                    <!-- start tab content -->
                                    <div class="panel panel-default <?php echo $active; ?>">
                                        <div class="panel-heading">
                                            <a class="accordion-toggle collapsed" data-toggle="collapse"
                                               data-parent="#accordion-main" href="#collapse<?php echo $i; ?>">
                                                <div class="panel-title">
                                                    <span><?php echo $i; ?></span>
                                                    <span><?php echo esc_html($faq['title']); ?></span>
                                                    <i class="pull-right fa fa-angle-down"></i>
                                                </div>
                                            </a>
                                        </div>
                                        <div id="collapse<?php echo $i; ?>"
                                             class="panel-collapse collapse <?php echo $in; ?>">
                                            <div class="panel-body"><?php echo esc_html($faq['desc']); ?></div>
                                        </div>
                                    </div>
                                    <!-- end tab content -->
                                    <?php
                                    $i++;
                                endforeach; ?>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
        </section>
        <!--FAQS AREA END-->
        <?php
    }
}
