<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_contact extends Widget_Base {

    public function get_name() {
        return 'applic-contact';
    }

    public function get_title() {
        return __( 'Contact', 'applic-core' );
    }

    public function get_icon() {
        return 'eicon-skill-bar';
    }

    public function get_categories() {
        return [ 'applic-elements' ];
    }

    protected function _register_controls() {

        /* ------------------------------  Contact Area content tab ------------------------------
        -------------------------------------------------------------------------------------*/
        /*-------------------------------- Section Content --------------------------------*/

        $this->start_controls_section(
            'sec_con_id',
            [
                'label' => __( 'Section Content', 'applic-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'applic-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Call Us Or Started To Talk With Us', 'applic-core' ),
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Subtitle', 'applic-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'CONTACT US', 'applic-core' ),
            ]
        );

        $this->end_controls_section(); // end Section content

        $this->start_controls_section(
            'contact_info_id',
            [
                'label' => __( 'Contact Info', 'applic-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'contact_lists', [
                'label' => __( 'Add Contact Info', 'applic-core' ),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ title }}}',
                'fields' => [
                    [
		                'name' => 'title',
		                'label' => __( 'Title', 'applic-core' ),
		                'type' => Controls_Manager::TEXT,
		                'label_block' => true,
		                'default' => 'Create Account'
	                ],
	                [
		                'name' => 'icon',
		                'label' => __( 'Icon', 'applic-core' ),
		                'type' => Controls_Manager::ICON
	                ],
                    [
                        'name' => 'info',
                        'label' => __( 'Information', 'applic-core' ),
                        'type' => Controls_Manager::TEXTAREA,
                        'label_block' => true,
                        'default' => '123 Chalingt Gates, Supper Market New York.'
                    ]
                ],
            ]
        );
        $this->end_controls_section(); // End Contact Info

	    $this->start_controls_section(
		    'con_form_id',
		    [
			    'label' => __( 'Contact Form', 'applic-core' ),
			    'tab'   => Controls_Manager::TAB_CONTENT,
		    ]
	    );

	    $this->add_control(
		    'form_code',
		    [
			    'label' => __( 'Form Shortcode', 'applic-core' ),
			    'type' => Controls_Manager::TEXTAREA,
			    'label_block' => true,
			    'default' => __( '[contact-form-7 id="143" title="Contact form 1"]', 'applic-core' ),
		    ]
	    );

	    $this->end_controls_section(); // End Contact Form Shortcode


        /*-------------------------------- Contact Area Style Tab --------------------------------*/
        $this->start_controls_section(
            'contact_style_id',
            [
                'label' => __( 'Background', 'applic-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

	    $this->add_control(
		    'bg_color',
		    [
			    'label'     => __( 'Background Color', 'applic-core' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .contact-area' => 'background: {{VALUE}};',
			    ],
		    ]
	    );

        $this->end_controls_section();

        $this->start_controls_section(
            'contact_s_con_id',
            [
                'label' => __( 'Title & Subtitle Style', 'applic-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Text Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .area-title h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'typography_title',
                'selector' => '{{WRAPPER}} .area-title h2',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label'     => __( 'Subtitle Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} h4.subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'typography_subtitle',
                'selector' => '{{WRAPPER}} h4.subtitle',
            ]
        );

        $this->end_controls_section();

	    $this->start_controls_section(
		    'contact_info_con_id',
		    [
			    'label' => __( 'Contact Info Style', 'applic-core' ),
			    'tab' => Controls_Manager::TAB_STYLE,
		    ]
	    );

	    $this->add_control(
		    'info_title',
		    [
			    'label'     => __( 'Title Color', 'applic-core' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .single-contact h3' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'info_color',
		    [
			    'label'     => __( 'Info Color', 'applic-core' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .single-contact p' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'info_icon_color',
		    [
			    'label'     => __( 'Icon Color', 'applic-core' ),
			    'type'      => Controls_Manager::COLOR,
			    'selectors' => [
				    '{{WRAPPER}} .contact-icon i' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->end_controls_section();

        $this->start_controls_section(
            'contact_submit_id',
            [
                'label' => __( 'Submit Button Style', 'applic-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            's_btn_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => __('Normal', 'applic-core'),
            ]
        );
        $this->add_control(
            'submit_label',
            [
                'label'     => __( 'Submit Label Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                 'selectors' => [
                    '{{WRAPPER}} .contact-area input.read-more.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            's_btn_color', [
                'label' => __( 'Submit Button Background Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            's_btn_color2', [
                'label' => __( 'Submit Button Background Color 02', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more::before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{s_btn_color.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => __('Hover', 'applic-core'),
            ]
        );
        $this->add_control(
            'submit_label_h',
            [
                'label'     => __( 'Submit Label Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-area input.read-more:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            's_btn_color_h', [
                'label' => __( 'Submit Button Background Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            's_btn_color2_h', [
                'label' => __( 'Submit Button Background Color 02', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more:hover::before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{s_btn_color_h.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();
	    $contact_lists  = isset( $settings['contact_lists'] ) ? $settings['contact_lists'] : '';
	    $form_code = $settings['form_code'];
            ?>
            <!--CONTACT AREA-->
            <section class="contact-area padding-100-50">
                <div class="container">
                    <div class="row">
                        <div class="col-md-6 col-lg-6 col-md-offset-3 col-lg-offset-3 col-sm-12 col-xs-12">
                            <div class="area-title center">
	                            <?php if(!empty($settings['subtitle'])): ?>
                                    <h4 class="subtitle"><?php echo esc_html($settings['subtitle']); ?></h4>
	                            <?php endif; ?>
                                <?php if(!empty($settings['title'])): ?>
                                    <h2><?php echo esc_html($settings['title']); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5 col-lg-5 col-sm-12 col-xs-12">
                            <div class="contact-content padding50 mb50">
                                <?php foreach ( $contact_lists  as $contact_list): ?>
                                    <div class="single-contact">
                                        <div class="contact-icon"><i class="<?php echo esc_attr($contact_list['icon']); ?>"></i></div>
                                        <h3><?php echo esc_html($contact_list['title']); ?></h3>
                                        <p><?php echo ($contact_list['info']); ?></p>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <div class="col-md-5 col-lg-5 col-md-offset-1 col-lg-offset-1 col-sm-12 col-xs-12">
                            <div class="contact-form mb50">
                                <?php echo do_shortcode($form_code); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--CONTACT AREA END-->
            <?php
    }
}
