<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use WP_Query;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_blog extends Widget_Base {

	public function get_name() {
		return 'applic-blog';
	}

	public function get_title() {
		return __( 'Applic Blog', 'applic-core' );
	}

	public function get_icon() {
		return 'eicon-post';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		// ----------------------------------------  Blog Section content ------------------------------
		$this->start_controls_section(
			'section_content_id',
			[
				'label' => __( 'Blot Section Content', 'applic-core' )
			]
		);
        $this->add_control(
            'post_type_slider',
            [
                'label'        => __( 'Slider Post?', 'ultimate' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Enable', 'ultimate' ),
                'label_off'    => __( 'Disable', 'ultimate' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Our Latest News And Blogs'
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Subtitle text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'BLOG & NEWS'
			]
		);
		$this->end_controls_section(); // End blog Section content


		/**
		 * Style Tab
		 * ------------------------------ Section Content Style ------------------------------
		 *
		 */
		/*----------------------- section title and subtitle ---------------------------- */
		$this->start_controls_section(
			'sec_content_style', [
				'label' => __( 'Section Content Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color', [
				'label'     => __( 'Title Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-area .area-title h2' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_title',
				'selector' => '{{WRAPPER}} .blog-area .area-title h2',
			]
		);
		$this->add_control(
			'subtitle_color', [
				'label'     => __( 'Subtitle Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-area .area-title h4' => 'color: {{VALUE}};',
				]
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'sec_title', [
				'label' => __( 'Blog Title Color', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->start_controls_tabs(
            'blog_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => __( 'Normal', 'applic-core' ),
            ]
        );
        $this->add_control(
            'b_title_color', [
                'label'     => __( 'Title Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .blog-post-details h3 a'  => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'     => 'typography_title_b',
                'selector' => '{{WRAPPER}} .blog-post-details h3 a',
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => __( 'Hover', 'applic-core' ),
            ]
        );

        $this->add_control(
            'title_color_hover', [
                'label'     => __( 'Blog Title Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                 'selectors' => [
                    '{{WRAPPER}} .blog-post-details > h3 > a:hover'  => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

        $this->start_controls_section(
            'sec_con', [
                'label' => __( 'Blog Subtitle Color', 'applic-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'b_subtitle_color', [
                'label'     => __( 'Subtitle Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-post-details p'  => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'     => 'typography_subtitle_b',
                'selector' => '{{WRAPPER}} .blog-post-details p',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'blog_btn', [
                'label' => __( 'Button Style', 'applic-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'blog_btn_tabs'
        );
        $this->start_controls_tab(
            'blog_normal_tab',
            [
                'label' => __( 'Normal', 'applic-core' ),
            ]
        );
        $this->add_control(
            'btn_text_color', [
                'label'     => __( 'Button Text Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                 'selectors' => [
                    '{{WRAPPER}} .read-more'  => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
            'btn_bg',
            [
                'label' => __( 'Background Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'btn_hover_tab',
            [
                'label' => __( 'Hover', 'applic-core' ),
            ]
        );

        $this->add_control(
            'btn_text_color_hover', [
                'label'     => __( 'Button Text Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more:hover'  => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'btn_bg_color_hover', [
                'label' => __( 'Button Background Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'btn_bg_color2', [
                'label' => __( 'Button Background Color 02', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more::before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{btn_bg_color_hover.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}

	protected function render() {
        $this->load_widget_script();
		$settings = $this->get_settings();
		$posts    = new WP_Query( array(
			'post_type'      => 'post',
			'posts_per_page' => 5,
		) );
		?>
        <!--BLOG AREA-->
        <section class="blog-area padding-100-50" id="blog">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-lg-6 col-md-offset-3 col-lg-offset-3 col-sm-12 col-xs-12">
                        <div class="area-title center">
							<?php if ( ! empty( $settings['subtitle'] ) ): ?>
                                <h4 class="subtitle"><?php echo esc_html( $settings['subtitle'] ); ?></h4>
							<?php endif; ?>
							<?php if ( ! empty( $settings['title'] ) ): ?>
                                <h2> <?php echo esc_html( $settings['title'] ); ?> </h2>
							<?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php if( $settings['post_type_slider'] == 'yes' ) : ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="blog__posts__slider">
                            <?php while ( $posts->have_posts() ) : $posts->the_post(); ?>
                                <div class="single-blog-item">
                                    <div class="post-media">
                                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'applic_360x263' ) ?></a>
                                    </div>
                                    <div class="blog-post-details">
                                        <h3><a href="<?php the_permalink(); ?>"> <?php the_title() ?></a></h3>
                                        <p><?php echo wp_trim_words( get_the_content(), 18, '' ) ?></p>
                                        <a href="<?php the_permalink() ?>" class="read-more"><?php _e( 'Read More', 'applic_core' ) ?></a>
                                    </div>
                                </div>
                            <?php endwhile; wp_reset_postdata(); ?>
                        </div>
                    </div>
                </div>
                <?php else: ?>
                <div class="row">
                    <?php
                    $i = 0;
                    while ( $posts->have_posts() ) : $posts->the_post();
                        if ( $i == 2 ) {
                            break;
                        }
                        ?>
                        <div class="col-md-6 col-lg-4 col-sm-6 col-xs-12">
                            <div class="single-blog-item mb50 wow fadeInLeft" data-wow-delay="0.3s">
                                <div class="post-media mb40">
                                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'applic_360x263' ) ?></a>
                                </div>
                                <div class="blog-post-details">
                                    <h3><a href="<?php the_permalink(); ?>"> <?php the_title() ?></a></h3>
                                    <p><?php echo wp_trim_words( get_the_content(), 20, '' ) ?></p>
                                    <a href="<?php the_permalink() ?>" class="read-more"><?php _e( 'Read More', 'applic_core' ) ?></a>
                                </div>
                            </div>
                        </div>
                        <?php
                        ++ $i;
                    endwhile;
                    wp_reset_postdata();
                    ?>
                    <div class="col-md-4 col-lg-4 col-sm-6 col-xs-12 hidden-md hidden-sm wow fadeInLeft"
                         data-wow-delay="0.9s">
                        <?php
                        $j = 0;
                        while ( $posts->have_posts() ) : $posts->the_post();
                            ?>
                            <div class="single-blog-item mb50">
                                <div class="blog-post-details">
                                    <h3><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h3>
                                    <p><?php echo wp_trim_words( get_the_content(), 12, '' ) ?></p>
                                    <a href="<?php the_permalink() ?>" class="read-more"><?php _e( 'Read More', 'applic_core' ) ?></a>
                                </div>
                            </div>
                            <hr class="mb50">
                            <?php
                            $j++;
                        endwhile;
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
                <?php endif; ?>

            </div>
        </section>
        <!--BLOG AREA END-->
		<?php
	}



    public function load_widget_script(){
        if( \Elementor\Plugin::$instance->editor->is_edit_mode() === true  ) { ?>
            <script>
                ( function( $ ){
                    var serviceCarousel = jQuery('.blog__posts__slider');
                    if (serviceCarousel.length > 0) {
                        serviceCarousel.owlCarousel({
                            merge: true,
                            smartSpeed: 1000,
                            loop: true,
                            nav: true,
                            center: false,
                            dots: false,
                            navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                            autoplay: false,
                            autoplayTimeout: 3000,
                            margin: 0,
                            responsiveClass: true,
                            responsive: {
                                0: {
                                    center: true,
                                    nav: false,
                                    dots: true,
                                    items: 1
                                },
                                600: {
                                    nav: false,
                                    dots: true,
                                    items: 2
                                },
                                1000: {
                                    items: 3
                                },
                                1200: {
                                    items: 3
                                }
                            }
                        });
                    }
                })(jQuery);
            </script>
            <?php
        }
    }



}
