<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_about_area extends Widget_Base {

	public function get_name() {
		return 'applic-about-area';
	}

	public function get_title() {
		return __( 'About Area', 'applic-core' );
	}

	public function get_icon() {
		return 'eicon-info-box';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		/* ------------------------------  About Area content tab ------------------------------
		-------------------------------------------------------------------------------------*/
		/*-------------------------------- About Area Style --------------------------------*/
		$this->start_controls_section(
			'about_style_id',
			[
				'label' => __( 'About Area Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style', [
				'label'       => esc_html__( 'Markup Style', 'applic-core' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => true,
				'options'     => [
					'style_01' => esc_html__( 'Markup One', 'applic-core' ),
					'style_02' => esc_html__( 'Markup Two', 'applic-core' ),
					'style_03' => esc_html__( 'Markup Three', 'applic-core' ),
					'style_04' => esc_html__( 'Markup Four', 'applic-core' )
				],
				'default'     => 'style_01'
			]
		);
		$this->end_controls_section(); // end About Area style


		$this->start_controls_section(
			'about_con_id',
			[
				'label' => __( 'About Area Content', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'about_img',
			[
				'label' => __( 'Choose Image', 'applic-core' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'applic-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Engage Your Customer Automatically', 'applic-core' ),
			]
		);
		$this->add_control(
			'content',
			[
				'label' => __( 'Content', 'applic-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 10,
				'label_block' => true,
				'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor inc ididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exerc itation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure.', 'applic-core' ),
				'condition'  => [
					'style' => [ 'style_01', 'style_02', 'style_04'],
				]
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label' => __( 'Subtitle', 'applic-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'WORKING PROGRESS', 'applic-core' ),
				'condition'  => [
					'style' => 'style_03',
				]
			]
		);
		$this->add_control(
			'icon',
			[
				'label' => __( 'Icons', 'applic-core' ),
				'type' => Controls_Manager::ICON,
				'condition'  => [
					'style' => [ 'style_01', 'style_02', 'style_04'],
				]
			]
		);
		$this->add_control(
			'btn_label',
			[
				'label' => __( 'Button Label', 'applic-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Get Started', 'applic-core' ),
				'condition'  => [
					'style' => [ 'style_01', 'style_02', 'style_04'],
				]
			]
		);
		$this->add_control(
			'btn_link',
			[
				'label' => __( 'Button URL', 'applic-core' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'applic-core' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition'  => [
					'style' => [ 'style_01', 'style_02', 'style_04'],
				]
			]
		);
		$this->end_controls_section(); // end About Area content

		$this->start_controls_section(
			'about_list_id',
			[
				'label' => __( 'About Area List', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition'  => [
					'style' => [ 'style_03'],
				]
			]
		);
		$this->add_control(
			'about_lists', [
				'label' => __( 'Add Lists', 'applic-core' ),
				'type' => Controls_Manager::REPEATER,
				'title_field' => '{{{ title }}}',
				'fields' => [
					[
						'name' => 'title',
						'label' => __( 'Title', 'applic-core' ),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => 'Create Account'
					],
					[
						'name' => 'desc',
						'label' => __( 'Description', 'applic-core' ),
						'type' => Controls_Manager::TEXTAREA,
						'label_block' => true,
                        'default' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit sed do eiusmod tempor incididunt ut.'
					],
                    [
                        'name' => 'icon',
                        'label' => __('Icon', 'applic-core'),
                        'type' => Controls_Manager::ICON,

                    ],
					[
					        'name' => 'icon_bg',
						'label'     => __( 'Icon Background Color', 'applic-core' ),
						'type'      => Controls_Manager::COLOR,
					]
				],
			]
		);
		$this->end_controls_section(); // end About Area style


		/*-------------------------------- About Area Style Tab --------------------------------*/
		$this->start_controls_section(
			'about_s_id',
			[
				'label' => __( 'Background', 'applic-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label'     => __( 'Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area' => 'background: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'about_s_con_id',
			[
				'label' => __( 'Section Style', 'applic-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .area-content h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_title',
				
				'selector' => '{{WRAPPER}} .about-area .area-content h3',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label'     => __( 'Content Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .area-content p' => 'color: {{VALUE}};',
				],
				'condition'  => [
					'style' => [ 'style_01', 'style_02', 'style_04'],
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_content',
				
				'selector' => '{{WRAPPER}} .about-area .area-content p',
				'condition'  => [
					'style' => [ 'style_01', 'style_02', 'style_04'],
				]
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label'     => __( 'Subtitle Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .subtitle' => 'color: {{VALUE}};',
				],
				'condition'  => [
					'style' => [ 'style_03'],
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_subtitle',
				'selector' => '{{WRAPPER}} .about-area .subtitle',
				'condition'  => [
					'style' => [ 'style_03'],
				]
			]
		);
		$this->end_controls_section();
		/**
		 * About Area Icon Style ( for all style)
		 **/
		$this->start_controls_section(
			'icon_s_id',
			[
				'label' => __( 'Icon Style', 'applic-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label'     => __( 'Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .details-content-box .box-icon, .about-process-box .box-icon' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

		/**
		 * About Area Button Style ( for style 01, 02, 04)
		 **/
		$this->start_controls_section(
			'about_btn_id',
			[
				'label' => __( 'Button Style', 'applic-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'  => [
					'style' => [ 'style_01', 'style_02', 'style_04'],
				]
			]
		);

        $this->start_controls_tabs(
            'btn_tabs'
        );
        $this->start_controls_tab(
            'a_btn_n',
            [
                'label' => __( 'Normal', 'applic-core' ),
            ]
        );
		$this->add_control(
			'btn_color',
			[
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .read-more.active' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_bg_color', [
				'label' => __( 'Button Background Color', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'btn_bg_color2', [
				'label' => __( 'Button Background Color 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .read-more::before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{btn_bg_color.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
				],
			]
		);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'a_btn_h',
            [
                'label' => __( 'Hover', 'applic-core' ),
            ]
        );
        $this->add_control(
            'btn_color_h',
            [
                'label'     => __( 'Text Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-area .read-more:hover.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_bg_color_h', [
                'label' => __( 'Button Background Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'btn_bg_color2_h', [
                'label' => __( 'Button Background Color 02', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .active:hover::before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{btn_bg_color_h.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();


		/**
         * About Area List Style ( for style 03)
		**/
		$this->start_controls_section(
			'about_list_style_id',
			[
				'label' => __( 'Lists Style', 'applic-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'  => [
					'style' => [ 'style_03']
				]
			]
		);
		$this->add_control(
			'a_list_title',
			[
				'label'     => __( 'Title Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-process-box h4' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_title_s',
				'selector' => '{{WRAPPER}} .about-process-box h4',
			]
		);
		$this->add_control(
			'desc_list',
			[
				'label'     => __( 'Description Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-process-box p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_desc_list',
				'selector' => '{{WRAPPER}} .about-process-box p',
			]
		);
		$this->end_controls_section();


	}

	protected function render() {
		$settings = $this->get_settings();
		$target = $settings['btn_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['btn_link']['nofollow'] ? ' rel="nofollow"' : '';
		if($settings['style'] == 'style_01') {
			?>
			<!--ABOUT AREA-->
			<section class="about-area section-padding">
				<div class="container">
					<div class="row">
						<div class="col-md-5 col-lg-5 col-sm-12 col-xs-12">
							<div class="area-image-content sm-mb50 xs-mb50 wow fadeInRight" data-wow-delay="0.3s">
								<img src="<?php echo esc_url($settings['about_img']['url'])?>" alt="<?php echo esc_attr($settings['title']); ?>">
							</div>
						</div>
						<div class="col-md-5 col-md-offset-1 col-lg-5 col-lg-offset-1 col-sm-12 col-xs-12">
							<div class="area-content">
                                <?php if(!empty($settings['title'])): ?>
								<h3 class="wow fadeInRight" data-wow-delay="0.3s"><?php echo esc_html($settings['title']); ?></h3>
            <?php endif; ?>
								<div class="text-icon-box details-content-box wow fadeInRight" data-wow-delay="0.6s">
									<div class="box-icon"><i class="<?php echo esc_attr($settings['icon']); ?>"></i></div>
                                    <?php if(!empty($settings['content'])): ?>
									<p><?php echo esc_html($settings['content']); ?></p>
                                    <?php endif;  ?>
                                    <?php if(!empty($settings['btn_label'])): ?>
									<a <?php echo $target ; ?> <?php echo $nofollow ; ?> href="<?php echo esc_url($settings['btn_link']['url'])?>" class="read-more active"><?php echo esc_html($settings['btn_label']); ?></a>
            <?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!--ABOUT AREA END-->
			<?php
		}elseif ( $settings['style'] == 'style_02'){
		    ?>
            <!--ABOUT AREA-->
            <section class="about-area section-padding">
                <div class="container-fluid">
                    <div class="row flex-v-center">
                        <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                            <div class="area-image-content sm-mb50 xs-mb50 wow fadeInRight" data-wow-delay="0.3s">
                                <img src="<?php echo esc_url($settings['about_img']['url'])?>" alt="<?php echo esc_attr($settings['title']); ?>">
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-4 col-sm-12 col-xs-12">
                            <div class="area-content area-2 m_l_70">
                                <h3 class="wow fadeInRight" data-wow-delay="0.3s"><?php echo esc_html($settings['title']); ?></h3>
                                <div class="text-icon-box details-content-box wow fadeInRight" data-wow-delay="0.6s">
                                    <div class="box-icon"><i class="<?php echo esc_attr($settings['icon']); ?>"></i></div>
	                                <?php if(!empty($settings['content'])): ?>
                                        <p><?php echo esc_html($settings['content']); ?></p>
	                                <?php endif;  ?>
                                    <a <?php echo $target ; ?> <?php echo $nofollow ; ?> href="<?php echo esc_url($settings['btn_link']['url'])?>" class="read-more active"><?php echo esc_html($settings['btn_label']); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--ABOUT AREA END-->
            <?php
        }
		elseif ( $settings['style'] == 'style_03' ){
			?>
			<!--ABOUT AREA-->
			<section class="about-area section-padding">
				<div class="container">
					<div class="row">
						<div class="col-md-7 col-lg-7 col-sm-12 col-xs-12">
							<div class="area-image-content sm-mb50 xs-mb50 wow fadeInRight" data-wow-delay="0.3s">
								<img src="<?php echo esc_url($settings['about_img']['url'])?>" alt="<?php echo esc_attr($settings['title']); ?>">
							</div>
						</div>
						<div class="col-md-5 col-lg-5 col-sm-12 col-xs-12">
							<div class="area-content">
								<h4 class="subtitle"><?php echo esc_html($settings['subtitle']); ?></h4>
								<h3 class="wow fadeInRight" data-wow-delay="0.3s"><?php echo esc_html($settings['title']); ?></h3>
                                <?php
                                $i = 1;
                                $d = 0.3;
                                    foreach ( $settings['about_lists'] as $abt_list ):
	                                    $mid_class = ($i % 2 == 0) ? 'hidden-md' : '';
                                        ?>
                                        <div class="text-icon-box about-process-box wow fadeInUp mb40 <?php echo $mid_class; ?>" data-wow-delay="<?php echo $d; ?>s">
                                            <div style="background: <?php echo $abt_list['icon_bg']; ?>" class="box-icon"><i class="<?php echo esc_attr($abt_list['icon']); ?>"></i></div>
                                            <h4 class="font20"><?php echo esc_html($abt_list['title']); ?></h4>
                                            <p><?php echo esc_html($abt_list['desc']); ?></p>
                                        </div>
                                        <?php
                                    $i++;
	                                    $d = $d + 0.3;
                                    endforeach;
                                ?>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!--ABOUT AREA END-->
			<?php
		}elseif ( $settings['style'] == 'style_04'){
		    ?>
            <!--ABOUT AREA-->
            <section class="about-area section-padding">
                <div class="container">
                    <div class="row flex-v-center">
                        <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                            <div class="area-image-content sm-mb50 xs-mb50 wow fadeInRight" data-wow-delay="0.3s">
                                <img src="<?php echo esc_url($settings['about_img']['url'])?>" alt="<?php echo esc_html($settings['title']); ?>">
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-5 col-sm-12 col-xs-12">
                            <div class="area-content">
                                <h3 class="wow fadeInRight" data-wow-delay="0.3s"><?php echo esc_html($settings['title']); ?></h3>
                                <div class="text-icon-box details-content-box wow fadeInRight" data-wow-delay="0.6s">
                                    <div class="box-icon"><i class="<?php echo esc_attr($settings['icon']); ?>"></i></div>
	                                <?php if(!empty($settings['content'])): ?>
                                        <p><?php echo esc_html($settings['content']); ?></p>
	                                <?php endif;  ?>
                                    <a <?php echo $target ; ?> <?php echo $nofollow ; ?> href="<?php echo esc_url($settings['btn_link']['url'])?>" class="read-more active"><?php echo esc_html($settings['btn_label']); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--ABOUT AREA END-->
<?php
        }
	}
}
